/**
* \file: gst_viv_renderer.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* GL Render Plugin using Vivante-Extensions for mapping
* YUV video streams to textures
*
* \component: gst_viv_demo
*
* \author: Michael Methner ADITG/SWG mmethner@de.adit-jv.com
*
* \copyright: (c) 2003 - 2011 ADIT Corporation
*
* \history
* 0.1 Michael Methner Initial version
***********************************************************************/

#ifndef __GST_VIV_RENDERER_H__
#define __GST_VIV_RENDERER_H__

#include <gst/gst.h>

#include <GLES2/gl2.h>
#include <EGL/egl.h>
#include <EGL/eglvivante.h>

G_BEGIN_DECLS


#define GST_TYPE_VIV_RENDERER \
  (gst_viv_renderer_get_type())
#define GST_VIV_RENDERER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_VIV_RENDERER,GstVivRenderer))
#define GST_VIV_RENDERER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_VIV_RENDERER,GstVivRendererClass))
#define GST_IS_VIV_RENDERER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_VIV_RENDERER))
#define GST_IS_VIV_RENDERER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_VIV_RENDERER))


#define GST_VIV_RENDERER_TEX_FORMAT_AUTODETECT 0


#define MAX_VIV_BUFFERS 6

typedef struct _GstVivRenderer GstVivRenderer;
typedef struct _GstVivRendererClass GstVivRendererClass;

struct _GstVivRenderer
{
  GstElement element;

  GstPad * sinkpad;
  GstPad * srcpad;
  GstCaps * src_caps;

  GMutex *pool_lock;
  GCond *pool_data;
  GSList *buffer_pool;

  gint src_width;
  gint src_height;
  GMutex *buffer_mutex;
  GstBuffer * buffer;
  GstClockTime timestamp;

  GHashTable *tex_id;
  GLenum texture_format;
  gboolean texture_tiled;

  guint looping_count;
  GstClockTime timestamp_incr;

  EGLDisplay eglDisplay;
  EGLContext eglContext;
  gboolean running;
};


struct _GstVivRendererClass
{
  GstElementClass parent_class;
  void (*render) (GstElement *element, GstPad *pad);
};


GType gst_viv_renderer_get_type(void);

GLuint gst_viv_renderer_get_current_texname(GstVivRenderer * sink);
GstClockTime gst_viv_renderer_get_current_timestamp(GstVivRenderer * sink);

void
gst_viv_renderer_set_egl(GstVivRenderer * renderer,
    EGLDisplay eglDisplay,EGLContext eglContext);

gboolean
gst_viv_renderer_add_pixmap(GstVivRenderer * renderer,
    EGLSurface egl_window_surface,  EGLNativeDisplayType native_display, EGLNativePixmapType native_pixmap);


G_END_DECLS

#endif /* __GST_VIV_RENDERER_H__ */
